package parser;

import token.*;

/**
 * Interface for an abstract factory for token visitors.
 */
public interface ITokVisitorFact {
  
  public String getName();
  
  /**
   * Make a token visitor for this symbol.
   *
   * @return A token visitor
   */
  public abstract ATokVisitor<IGrammarSymbol, Object> makeVisitor();
  
  /**
   * Make a token visitor that will process the combination of this 
   * or the other given symbol 
   *
   * @param other The visitor for the other symbol in the combination 
   * @return A token visitor
   */
  public abstract ATokVisitor<IGrammarSymbol, Object> makeCombinedVisitor(ATokVisitor<IGrammarSymbol, Object> other);
}

